const express = require('express');
const router = express.Router();
const { protect } = require('../middleware/authMiddleware');
const { isAdmin } = require('../middleware/adminMiddleware');
const {
    getAllCoupons,
    getActiveCoupons,
    validateCoupon,
    createCoupon,
    updateCoupon,
    deleteCoupon
} = require('../controllers/couponController');

// Public routes
router.get('/active', getActiveCoupons);
router.post('/validate', protect, validateCoupon);

// Admin routes
router.get('/', protect, isAdmin, getAllCoupons);
router.post('/', protect, isAdmin, createCoupon);
router.put('/:couponId', protect, isAdmin, updateCoupon);
router.delete('/:couponId', protect, isAdmin, deleteCoupon);

module.exports = router;

