const mongoose = require('mongoose');

const couponSchema = new mongoose.Schema({
    code: {
        type: String,
        required: true,
        unique: true,
        uppercase: true,
        trim: true
    },
    discountType: {
        type: String,
        enum: ['percentage', 'flat'],
        required: true
    },
    value: {
        type: Number,
        required: true,
        min: 0
    },
    applicablePlans: [{
        type: String,
        enum: ['premium-individual', 'team', 'small-company', 'medium-company', 'large-company']
    }],
    expiryDate: {
        type: Date,
        required: true
    },
    maxUses: {
        type: Number,
        default: 1
    },
    usedBy: [{
        user: {
            type: mongoose.Schema.Types.ObjectId,
            ref: 'User'
        },
        usedAt: {
            type: Date,
            default: Date.now
        }
    }],
    active: {
        type: Boolean,
        default: true
    },
    description: {
        type: String
    }
}, { timestamps: true });

// Index for faster lookups
couponSchema.index({ code: 1 });
couponSchema.index({ active: 1, expiryDate: 1 });

module.exports = mongoose.model('Coupon', couponSchema);

