const mongoose = require('mongoose');

const activationRequestSchema = new mongoose.Schema({
    user: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'User',
        required: true
    },
    userEmail: {
        type: String,
        required: true
    },
    planId: {
        type: String,
        required: true,
        enum: ['premium-individual', 'team', 'small-company', 'medium-company', 'large-company']
    },
    durationType: {
        type: String,
        enum: ['monthly', 'yearly', 'custom'],
        required: true
    },
    months: {
        type: Number,
        required: true,
        min: 1
    },
    paymentScreenshotURL: {
        type: String,
        required: true
    },
    status: {
        type: String,
        enum: ['pending', 'approved', 'rejected', 'expired'],
        default: 'pending'
    },
    requestedAmount: {
        type: Number,
        required: true
    },
    discountApplied: {
        type: Number,
        default: 0
    },
    couponCode: {
        type: String,
        default: null
    },
    finalAmount: {
        type: Number,
        required: true
    },
    adminNotes: {
        type: String,
        default: ''
    },
    activatedAt: {
        type: Date
    },
    approvedBy: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'User'
    },
    rejectedAt: {
        type: Date
    },
    rejectionReason: {
        type: String
    }
}, { timestamps: true });

// Index for faster queries
activationRequestSchema.index({ status: 1, createdAt: -1 });
activationRequestSchema.index({ user: 1 });

module.exports = mongoose.model('ActivationRequest', activationRequestSchema);

