require('dotenv').config();
const mongoose = require('mongoose');
const bcrypt = require('bcryptjs');
const User = require('../models/User');

// Admin user details
const adminUser = {
    name: 'Admin',
    email: 'admin@tasktree.com',
    password: 'Admin@123',
    role: 'admin',
    isVerified: true,
    status: 'active'
};

// Connect to MongoDB
mongoose.connect(process.env.MONGO_URI)
    .then(async () => {
        console.log('Connected to MongoDB');

        try {
            // Check if admin already exists
            const existingAdmin = await User.findOne({ email: adminUser.email });
            if (existingAdmin) {
                console.log('Admin user already exists');
                process.exit(0);
            }

            // Hash password
            const salt = await bcrypt.genSalt(10);
            const hashedPassword = await bcrypt.hash(adminUser.password, salt);

            // Create admin user
            const admin = new User({
                ...adminUser,
                password: hashedPassword
            });

            await admin.save();
            console.log('Admin user created successfully');
            console.log('Email:', adminUser.email);
            console.log('Password:', adminUser.password);
        } catch (error) {
            console.error('Error creating admin user:', error);
        }

        process.exit(0);
    })
    .catch(err => {
        console.error('MongoDB connection error:', err);
        process.exit(1);
    });