const express = require('express');
const router = express.Router();
const { protect } = require('../middleware/authMiddleware');
const { isAdmin } = require('../middleware/adminMiddleware');
const {
    getPricingPlans,
    getSubscriptionStatus,
    calculatePrice,
    createActivationRequest,
    getUserActivationRequests,
    getAllActivationRequests,
    approveActivationRequest,
    rejectActivationRequest
} = require('../controllers/premiumController');

// Public routes
router.get('/plans', getPricingPlans);

// User routes
router.get('/subscription', protect, getSubscriptionStatus);
router.post('/calculate-price', protect, calculatePrice);
router.post('/activation-request', protect, createActivationRequest);
router.get('/activation-requests', protect, getUserActivationRequests);

// Admin routes
router.get('/admin/activation-requests', protect, isAdmin, getAllActivationRequests);
router.post('/admin/activation-requests/:requestId/approve', protect, isAdmin, approveActivationRequest);
router.post('/admin/activation-requests/:requestId/reject', protect, isAdmin, rejectActivationRequest);

module.exports = router;

