const express = require('express');
const { protect } = require('../middleware/authMiddleware');
const {
    createCourse,
    getAllCourses,
    getCourse,
    subscribeToCourse,
    getMyCourses,
    updateCourse,
    deleteCourse
} = require('../controllers/courseController');

const router = express.Router();

// Public routes
router.get('/', getAllCourses);
router.get('/:courseId', getCourse);

// Protected routes
router.use(protect);

router.post('/', createCourse);
router.post('/:courseId/subscribe', subscribeToCourse);
router.get('/my/enrolled', getMyCourses);
router.put('/:courseId', updateCourse);
router.delete('/:courseId', deleteCourse);

module.exports = router;

