const mongoose = require('mongoose');

const eventSchema = new mongoose.Schema({
    title: {
        type: String,
        required: true,
        trim: true
    },
    description: {
        type: String,
        trim: true
    },
    startDate: {
        type: Date,
        required: true
    },
    endDate: {
        type: Date,
        required: true
    },
    allDay: {
        type: Boolean,
        default: false
    },
    userId: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'User',
        required: true
    },
    workspaceId: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'Workspace',
        required: true
    },
    reminder: {
        enabled: {
            type: Boolean,
            default: false
        },
        minutes: {
            type: Number,
            default: 10 // minutes before event
        }
    },
    color: {
        type: String,
        default: '#10B981' // Green color for events
    },
    type: {
        type: String,
        default: 'event'
    }
}, {
    timestamps: true
});

// Index for efficient queries
eventSchema.index({ userId: 1, startDate: 1 });
eventSchema.index({ userId: 1, workspaceId: 1 });

module.exports = mongoose.model('Event', eventSchema);