const mongoose = require('mongoose');

const AttemptSchema = new mongoose.Schema({
  attempt: { type: Number },
  code: { type: Number, default: null },
  reason: { type: String },
  timestamp: { type: Date, default: Date.now }
}, { _id: false });

const ItemSchema = new mongoose.Schema({
  to: { type: String, required: true },
  userId: { type: String },
  message: { type: String },
  status: { type: String, enum: ['sent', 'failed', 'skipped', 'dry_run'], default: 'sent' },
  attempts: { type: Number, default: 0 },
  attemptsLog: [AttemptSchema],
  sentAt: { type: Date }
}, { _id: false });

const AutomationReportSchema = new mongoose.Schema({
  type: { type: String, enum: ['titi', 'daily'], required: true },
  runId: { type: String },
  startedAt: { type: Date, default: Date.now },
  endedAt: { type: Date },
  dryRun: { type: Boolean, default: false },
  total: { type: Number, default: 0 },
  processed: { type: Number, default: 0 },
  successCount: { type: Number, default: 0 },
  failCount: { type: Number, default: 0 },
  items: [ItemSchema]
}, { timestamps: true });

module.exports = mongoose.model('AutomationReport', AutomationReportSchema);