const mongoose = require('mongoose');

const AnalyticsSchema = new mongoose.Schema({
    totalUsers: { type: Number, default: 0 },
    activeUsers: { type: Number, default: 0 },
    totalWorkspaces: { type: Number, default: 0 },
    totalSections: { type: Number, default: 0 },
    totalTasks: { type: Number, default: 0 },
    completedTasks: { type: Number, default: 0 },
    usersByRole: {
        admin: { type: Number, default: 0 },
        solo: { type: Number, default: 0 },
        team: { type: Number, default: 0 },
        company: { type: Number, default: 0 }
    },
    dailyActiveUsers: [{
        date: { type: Date },
        count: { type: Number }
    }],
    taskCompletionRate: { type: Number, default: 0 }, // Percentage
    averageTasksPerUser: { type: Number, default: 0 },
    lastUpdated: { type: Date, default: Date.now }
}, { timestamps: true });

module.exports = mongoose.model('Analytics', AnalyticsSchema);